/*	dirhdl.c	1.7	83/05/13	*/

#include <stdio.h>
#include "cpmio.h"

/* Display cp/m directory on stdout */

cpm_dispdir(struct cpmfs *cpmfs)
{
	int cnt, i;
	int filecnt = 0;
	int blkcnt ;
	char name[8], ext[3];
	int	freeblk;

	for (cnt=0; cnt<cpmfs->maxdir; cnt++) {
	    if ((cpmfs->dirbuf+cnt)->status != (char) 0xe5) {
		if ((cpmfs->dirbuf+cnt)->extno == '\0' ) {
		    strncpy(name, (cpmfs->dirbuf+cnt)->name, 8);
		    strncpy(ext, (cpmfs->dirbuf+cnt)->ext, 3);
		    for(i = 0; i < 8; i++) name[i] &= 0x7f;
		    for(i = 0; i < 3; i++) ext[i] &= 0x7f;
		    printf("%.8s %.3s",name,ext);
		    if (++filecnt%4 == 0) {
			printf("\n");  fflush(stdout);
		    } else {
			printf("   :   ");
		    }
		}
	    }
	}
	blkcnt = cpm_blks_used(cpmfs);
	freeblk = cpmfs->seclth*cpmfs->sectrk*(cpmfs->tracks-cpmfs->restrk)/cpmfs->blksiz - blkcnt;

	if (filecnt%4 > 0)
            printf("\n");
        if (filecnt == 0) {
	    printf("No files\n");
	} else {
	    printf("Total of %d files. %d block%s used.  Free space: %d block%s (%dk)\n",
		   filecnt, 
		   blkcnt, (blkcnt==1)?"":"s",
		   freeblk, (freeblk==1)?"":"s",
		   freeblk*cpmfs->blksiz/1024);
	}
		       
	return;
}

int
cpm_getdir(struct cpmfs *cpmfs)
{
	int bl, blks;
	int offset = 0;

	blks = cpmfs->maxdir*32/cpmfs->blksiz;
	if ((cpmfs->maxdir*32)%cpmfs->blksiz > 0) 
		++blks;

	for (bl = 0; blks > 0; bl++, blks--) {
		if (!cpm_getblock(cpmfs, bl,cpmfs->dirbuf+offset,-1)) {
		    return(FALSE);
		}
		offset += cpmfs->blksiz/32;
	}
	return(TRUE);
}

int
cpm_savedir(struct cpmfs *cpmfs)
{

	int bl, blks;
	int offset = 0;

	blks = cpmfs->maxdir*32/cpmfs->blksiz;
	if ((cpmfs->maxdir*32)%cpmfs->blksiz > 0) 
		++blks;
	for (bl = 0; blks > 0; bl++, blks--) {
		if (!cpm_putblock(cpmfs, bl,cpmfs->dirbuf+offset,-1)) {
		    return(FALSE);
		}
		offset += cpmfs->blksiz/32;
	}

	return(TRUE);
}

/* Search the cp/m directory for the file given by the input
 * parameters, return -1 if not found,
 * directory index to the file's first extent is
 * returned if found.
 */

cpm_searchdir(struct cpmfs *cpmfs, char *name, char *ext)
{
	int ind, i;
	char cname[8], cext[3];

	for (ind = 0; ind < cpmfs->maxdir; ++ind) 
	{
		strncpy(cname, (cpmfs->dirbuf+ind)->name, 8);
		strncpy(cext, (cpmfs->dirbuf+ind)->ext, 3);
		for(i = 0; i < 8; i++) cname[i] &= 0x7f;
		for(i = 0; i < 3; i++) cext[i] &= 0x7f;
		if ((cpmfs->dirbuf+ind)->status == (char) 0xe5) continue;

		if ((strncmp(name, cname, 8) == 0) &&
		    (strncmp(ext, cext, 3) == 0) &&
		    ((cpmfs->dirbuf+ind)->extno == '\0')) return(ind);
	}
	return(-1);
}
